
#ifndef gridparmH
#define gridparmH

#include <fstream>
using namespace std;

class GridParam
{
    private:
    	//minimal and maximum range of x
        double xmin, xmax;

        //minimal and maximum range of y
        double ymin, ymax;

        //minimal and maximum range of z
        double zmin, zmax;

        //knots of the grid
        long int nx, ny, nz;

        //dimension
        long int dim;

        //sets dimension
        void SetDim();

        long int Round(const double &) const;
    public:
        /* The non-argument constructor.
    	   This constructors sets default parameter values:
        		xmin = -1; ymin = 1;
    			zmin = 0;  xmax = 0;
    			ymax = 0;  zmax = 0;
    			nx=10;	   ny=0;
    			nz=0;
    			dim=1; */
        GridParam();

        /* 	This constructor reads parameters from file.
    		The file have to fillowing form:

    			xmin xmax nx
        		ymin ymax ny
        		zmin zmax nz */
        GridParam(ifstream &);

        /* 	If ymin=ymax=0 then dim=1,
        	if zmin=zmax=0 then dim=2
        	else dim=3 */
        GridParam(const double &xmin, const double &xmax, const long int &nx,
                  const double &ymin=0, const double &ymax=0, const long int &ny=0,
                  const double &zmin=0, const double &zmax=0, const long int &nz=0);

        //reads parameters from file
        void FromFile(ifstream &);

        //sets xmin, xmax , nx
        void SetXRange(const double &, const double &, const long int &);
        //sets ymin, ymax , ny
        void SetYRange(const double &, const double &, const long int &);
        //sets zmin, zmax , nz
        void SetZRange(const double &, const double &, const long int &);

        //gets xmin, xmax, nx
        void GetXRange(double &, double &, long int &) const;
        //gets ymin, ymax, ny
        void GetYRange(double &, double &, long int &) const;
        //gets zmin, zmax, nz
        void GetZRange(double &, double &, long int &) const;

        //get increase dx, dy or dz
        double GetDx() const;
        double GetDy() const;
        double GetDz() const;

        //gets knots of the grid
        long int GetNx() const;
        long int GetNy() const;
        long int GetNz() const;

        //gets spatial dimension
        long int GetDim() const;
        
        //returns:
        //nx 	   - in case of 1D
        //nx*ny    - in case of 2D
        //nx*ny*nz - in case of 3D
        long int GetNmax() const;

        //gets minimal and maximum of spatial range
        double GetXmin() const;
        double GetYmin() const;
        double GetZmin() const;
        double GetXmax() const;
        double GetYmax() const;
        double GetZmax() const;

        //operator =
        GridParam &operator=(const GridParam &);

        long int GetIndexX(const double &);
        long int GetIndexY(const double &);
        long int GetIndexZ(const double &);
};

#endif

